<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;


class LoginController extends Controller
{
    public function loginForm(){
        return view('auth.login');
    }

    public function login(Request $request){
        $this->validate($request,[
            'correo' => 'required|string',
            'password' => 'required|string',

        ]);

        if(Auth::attempt(['correo' => $request->correo,'password' => $request->password,'condicion'=>1])){

            Session::put('rol', Auth::user()->rol);
            return redirect()->route('main');
        }
        
        return back()->withErrors(['correo' => trans('auth.failed')]);
        
    }

    public function logout(Request $request){
        Auth::logout();
        $request->session()->invalidate();
        return redirect('/');
    }
}
