# time-stamp [![NPM version](https://img.shields.io/npm/v/time-stamp.svg?style=flat)](https://www.npmjs.com/package/time-stamp) [![NPM monthly downloads](https://img.shields.io/npm/dm/time-stamp.svg?style=flat)](https://npmjs.org/package/time-stamp) [![NPM total downloads](https://img.shields.io/npm/dt/time-stamp.svg?style=flat)](https://npmjs.org/package/time-stamp) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/time-stamp.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/time-stamp)

> Get a formatted timestamp.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save time-stamp
```

## v2.0.0

**Breaking changes**

Default pattern was changed from `YYYY:MM:DD` to `YYYY-MM-DD`. See https://github.com/jonschlinkert/time-stamp/issues/3 for more details.

## Usage

```js
var timestamp = require('time-stamp');

timestamp();
//=> 2017-05-14

timestamp('YYYYMMDD');
//=> 20170514

timestamp('YYYYMMDD:ss');
//=> 20170514:10

timestamp('YYYY/MM/DD:mm:ss');
//=> 2017/05/14:30:10

timestamp('YYYY:MM:DD');
//=> 2017:05:14

timestamp('[YYYY:MM:DD]');
//=> [2017:05:14]

timestamp('YYYY/MM/DD');
//=> 2017/05/14

timestamp('YYYY:MM');
//=> 2017:05

timestamp('YYYY');
//=> 2017

timestamp('MM');
//=> 05

timestamp('DD');
//=> 14

timestamp('HH');
//=> 21

timestamp('mm');
//=> 30

timestamp('ss');
//=> 10

timestamp('ms');
//=> 365
```

**Valid patterns**

* `YYYY`: full year (ex: **2017**)
* `MM`: month (ex: **04**)
* `DD`: day (ex: **01**)
* `HH`: hours (ex: **12**)
* `mm`: minutes (ex: **59**)
* `ss`: seconds (ex: **09**)
* `ms`: milliseconds (ex: **532**)

## About

### Related projects

* [days](https://www.npmjs.com/package/days): Days of the week. | [homepage](https://github.com/jonschlinkert/days "Days of the week.")
* [iso-week](https://www.npmjs.com/package/iso-week): Get the ISO week of the year. | [homepage](https://github.com/jonschlinkert/iso-week "Get the ISO week of the year.")
* [month](https://www.npmjs.com/package/month): Get the name or number of the current month or any month of the year. | [homepage](https://github.com/datetime/month "Get the name or number of the current month or any month of the year.")
* [months](https://www.npmjs.com/package/months): Months of the year. | [homepage](https://github.com/jonschlinkert/months "Months of the year.")
* [o-clock](https://www.npmjs.com/package/o-clock): Simple javascript utility for displaying the time in 12-hour clock format. | [homepage](https://github.com/jonschlinkert/o-clock "Simple javascript utility for displaying the time in 12-hour clock format.")
* [seconds](https://www.npmjs.com/package/seconds): Get the number of seconds for a minute, hour, day and week. | [homepage](https://github.com/jonschlinkert/seconds "Get the number of seconds for a minute, hour, day and week.")
* [week](https://www.npmjs.com/package/week): Get the current week number. | [homepage](https://github.com/datetime/week "Get the current week number.")
* [weekday](https://www.npmjs.com/package/weekday): Get the name and number of the current weekday. Or get the name of the… [more](https://github.com/datetime/weekday) | [homepage](https://github.com/datetime/weekday "Get the name and number of the current weekday. Or get the name of the weekday for a given number.")
* [year](https://www.npmjs.com/package/year): Simple utility to get the current year with 2 or 4 digits. | [homepage](https://github.com/jonschlinkert/year "Simple utility to get the current year with 2 or 4 digits.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** | 
| --- | --- |
| 21 | [jonschlinkert](https://github.com/jonschlinkert) |
| 1 | [evocateur](https://github.com/evocateur) |
| 1 | [mendenhallmagic](https://github.com/mendenhallmagic) |

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on May 14, 2017._